function falwspol=wvdecomp(dana);

%WVDECOMP wavelet decompositioan (based on Daubechies D5 wavelet)
%	COEFF=WVDECOMP(X) gives a wavelet coefficients of the signals in columns 
%   of the array X. 
%	COEFF is a "self explaining" cell array:
%   number of row on the left, "explonation" in the middle and data on the right 
%	eg. coeff = {
%	  [1]		'556  1222'    [1024x100  double]		%wv coeefs on the 1st level (freq range ~556-1222 Hz)
%	  [2]		'278  611'     [ 512x100  double]		%wv coeffs on the 2nd level (freq range ~278-611 Hz)
%	  [3]		'139  306'     [ 256x100  double]
%	  [4]		'69  153'      [ 128x100  double]
%	  [5]		'35  76'       [  64x100  double]
%	  [6]		'17  38'       [  32x100  double]		%wv coeffs on the last level (freq range ...)
%	  [7]		'0  21'        [  32x100  double]		%scaling function coeffs on the last level (freq range ~0-...)	
%	  [8]		'time'         [   1x2048 double]		vector containing the time axis 
%	  [9]		'samprate'     [            2000]		sampling rate (Hz)
%	  [10]	'level'            [               6]		number of levels used in decomposition
%	  [11]	'offset'           [               0]		length of offset (in points)
%	  [12]	'range'            [   7x4    double]	    wavelet and scaling function freqency ranges on all levels (Hz)
%
%	Signal length must be dividable by 2^N (where N is number of used
%	levels).
%
%   You may throw out (make equal zero) some coefficients before 
%   reconstruction. Throwing out coefficients at given level means filtering 
%   out the frequencies corresponding to this level from the signal. 
%	To rekonstruct a signal use function WVRECONSTR.M
%	If all (not changed) coefficients will be used to reconstruction then 
%   the reconstucted signal will by equal to original signal with relative 
%   error smaller then 1/1000 besides 3*2^N points long ends of the signal 
%   (where N is a number of level used in decomposition).
%
%	ATTENTION!!!
%   The file wvscal.mat must be present in current directory or in other 
%   directory with active path. (this file is needed for preliminary plots).
%
%	See also WVRECONSTR, MAKEWV

%copyright (c) 2002 by Marek Wypych
%Laboratory of Visual System
%Nencki Institute of Experimental Biology, 3 Pasteur Street, 02-093 Warsaw, Poland;


difolcik={'2000','0'};
teksciki={'Sampling rate of your signal [Hz]',...
      'Offset length (in points)'};		%tylko do skonstruowania osi czasu (i rysowania obrazka)
informacyjka=inputdlg(teksciki,'Hallo!',1,difolcik);

if length(informacyjka)==2	%jesli klikniete zostalo "Ok"
   
   
   samplrate=str2num(informacyjka{1});
   offsecik=str2num(informacyjka{2});
   
   [m_dl,n_szer]=size(dana);
   
   tajmik=linspace(1/samplrate-offsecik/samplrate,(m_dl-offsecik)/samplrate,m_dl);
   tajmik=tajmik*1000;	%os czasu w milisekundach
   
   meandatka=detrend(mean(dana,2),0);	%sredni sygnal do rysunku
   meandatka=meandatka/norm(meandatka);
   
   figurka=figure;
   
   %ilosc poziomow przedstawionych na obrazku
   poziomki=floor(log2(m_dl/14));	%zeby na obrazku nie wylazilo poza sygnal
   poziomki=min(poziomki,10);	%bo wiecej niz 10 nie ma w plilku falfskal.mat
   
   
   subplot(poziomki+1,1,1);hold on;
   plot(tajmik,meandatka);
   title('Press any key after you watched the plots.');
   xlabel('time [ms]');
   aksisy=axis;
   axis([tajmik(1),tajmik(end),aksisy(3),aksisy(4)]);
   
   
   load wvscal;	%ladowanie falek i funkcji do obrazkow, bo wyliczanie dlugo trwa
   lenL=10;	%jesli inny filtr falkowy, to inaczej
   
   
   for J=1:poziomki	%rysowanie obrazka
      
      %UWAGA!!!
      %Jesli uzyty byl inny filtr (inna falka), to czestosci beda zapewne inne!!!
      fDol=round(5*(samplrate/((lenL-1)*2^J)));	%dolna czestosc filtru falkowego
      fGor=round(11*(samplrate/((lenL-1)*2^J)));	%gorna czestosc filtra falkowego
      sGor=round(6*(samplrate/((lenL-1)*2^J)));	%gorna czestosc filtra dolnoprzepustowego (f. skalujacej)
      
      zakresy(J,:)=[fDol,fGor,0,sGor];	
      
      subplot(poziomki+1,1,J+1);hold on;
      %rysowanie falek
      for K=8:9	%przy falkach o dluzszym filtrze moze sie wywrocic      
         poczateczek=(K-lenL/2-1)*2^J-2	;
         koncoweczka=poczateczek+(lenL-1)*2^J-1;            
         plot(tajmik(poczateczek:koncoweczka),falfskal{J,1});
      end;
      %rysowanie funkcji skalujacych
      for K=10:11	%przy falkach o dluzszym filtrze moze sie wywrocic
         poczateczek=(K-lenL/2-1)*2^J-2	;
         koncoweczka=poczateczek+(lenL-1)*2^J-1;            
         plot(tajmik(poczateczek:koncoweczka),falfskal{J,2},'m');
      end;
      aksisy=axis;
      axis([tajmik(1),tajmik(end),aksisy(3),aksisy(4)]);
      
      title(['wavelets [',num2str(fDol),' - ',num2str(fGor),' Hz](blue), scaling function [0 - ',num2str(sGor),' Hz](magenta)']);	
      xlabel('time [ms]');
      ylabel(['level ',int2str(J)]);
      
   end;	%for J=1:poziomki
   
   pause;	%zeby sobie poogladac
   
   difolcik={'5'};
   teksciki={'Number of levels of decomposition'};
   informacyjka=inputdlg(teksciki,'Number of levels',1,difolcik);
   
   close(figurka);
   
   if length(informacyjka)==1	%Jesli klikniete bylo "Ok"
      
      poziomy=str2num(informacyjka{1});		%Ilosc poziomow rozciagania
      
      clear zakresy;	%skasowanie, bo pod spodem zrobione bedzie jeszcze raz
      
      for J=1:poziomy	%zapisanie zakresow czestosci uzywanych do dekompozycji
         
         fDol=round(5*(samplrate/((lenL-1)*2^J)));	%dolna czestosc filtru falkowego
         fGor=round(11*(samplrate/((lenL-1)*2^J)));	%gorna czestosc filtra falkowego
         sGor=round(6*(samplrate/((lenL-1)*2^J)));	%gorna czestosc filtra dolnoprzepustowego (f. skalujacej)
         
         zakresy(J,:)=[fDol,fGor,0,sGor];	%macierz z zakresami czestotliwosciowymi (falki i funkcji skalujacej) na kolejnych poziomach
         czestosci(J,:)=[fDol,fGor];   %letka redundancja
      end;
      
      czestosci(J+1,:)=[0,sGor];
      
      
      %"SERCE" SKRYPTU:
      dupafal=decomp(dana,poziomy);	%uzycie podfunkcji do wlasciwej decompozycji
      
      
      for J=1:poziomy+1
         
         falwspol{J,3}=dupafal{J};	%wstawianie do nowej macierzy         
         falwspol{J,2}=num2str(czestosci(J,:));	%wstawianie do nowej macierzy
         falwspol{J,1}=J;
         
      end;
      
      %KONIEC "SERCA" SKRYPTU.
      
      falwspol{poziomy+2,1}=poziomy+2;      
      falwspol{poziomy+2,2}='time';	%wstawianie "dodatkow" do nowej macierzy
      falwspol{poziomy+2,3}=tajmik;      
      falwspol{poziomy+3,1}=poziomy+3;
      falwspol{poziomy+3,2}='samplrate';	%wstawianie "dodatkow" do nowej macierzy
      falwspol{poziomy+3,3}=samplrate;      
      falwspol{poziomy+4,1}=poziomy+4;
      falwspol{poziomy+4,2}='level';	%wstawianie "dodatkow" do nowej macierzy
      falwspol{poziomy+4,3}=poziomy;      
      falwspol{poziomy+5,1}=poziomy+5;
      falwspol{poziomy+5,2}='offset';	%wstawianie "dodatkow" do nowej macierzy
      falwspol{poziomy+5,3}=offsecik;
      falwspol{poziomy+6,1}=poziomy+6;
      falwspol{poziomy+6,2}='range';	%wstawianie "dodatkow" do nowej macierzy
      falwspol{poziomy+6,3}=zakresy;
      
   end;	%if length(informacyjka)==1
end;	%if length(informacyjka)==2


%------------------------------------
%subfunction 'decomp'
function wspol=decomp(dupa,poziomy);

%DECOMP - dekompozycja falkowa (dyskretna transformata falkowa).
%	DECOMP(X,N) - daje w wyniku macierz komorkowa ze wspolczynnikami
%	falkowymi poszczegolnych kolumn macierzy X.
%	Kolejne komorki, to wyniki dzialania na roznych poziomach filtru
%	dolno (Lowpass) i gorno przepustowego (Highpass). Dokladniej, to 
%	pierwsze N komorek to wyniki dzialania filtru gornoprzepustowego 
%	(iloczyny skalarne z falkami), a N+1-sza to wynik dzialania filtru 
%	dolnoprzepustowego (iloczyny skalarne z funkcja skalujaca).
%	Uzyta jest falka D5 (Daubechies).
%
%	Sygnaly musza miec dlugosc 2^N lub wielokrotnosc (N to ilosc poziomow)
%	i zapasy ~3*2^N  punktow na obu koncach, bo beda tam znieksztalcenia
%	(w pozostalych punktach blad wzgledny w pelnej rekonstrukcji nie 
%	przekroczy 1/1000).
%

%copyright (c) 2002 by Marek Wypych
%Laboratory of Visual System
%Nencki Institute of Experimental Biology, 3 Pasteur Street, 02-093 Warsaw, Poland;


%fL to lowpass filter (filtr dolnoprzepustowy - odpowiadajacy funkcji skalujacej)
%do falki Daubechies D5 - jest to 10 wspolczynnikow 
%
%UWAGA!!!
%W tej funkcji oraz WVRECONSTR.M i WVROBFALKEF.M musi byc uzyty dokladnie ten sam filtr.

fL =[0.16010239797419  0.60382926979719  0.72430852843777    0.13842814590132  -0.24229488706638  -0.03224486958464  0.07757149384005  -0.00624149021280  -0.01258075199908  0.00333572528547 ];	%D10 scaling function

lenL=length(fL);

%filtr gornoprzepustowy (highpass filter) fH:
for i=1:lenL		
   fH(i)=fL(lenL-i+1)*(-1)^(i+1);
end;

lenH=length(fH);	%w zasadzie to ciut bez sensu, bo w przypadku falek Daubechies
%zawsze dlugosci filtrow beda takie same


[a,b]=size(fL);if a==1 fL=fL';end;	
[a,b]=size(fH);if a==1 fH=fH';end;
%musi tak byc, zeby filtry i sygnaly byly "pionowe" (kolumny), 
%bo uzywane bedzie conv2, a nie conv, co znacznie przyspiesza, 
%bo mozna filtrowac od razu cala macierz


%Pierwszy poziom odpowiada za najwyzsze czestosci, kolejny za nizsze itd
%Po ostatnim poziomie zostaje reszta "residuum", ktore "zalatwiane jest"
%przez fukcje skalujace (lowpass filter fL) - dlatego przy rekonstrukcji
%uzywane bedzie dupaL{poziomy}, a nie tylko dupaH (dupaH to wspolczynniki rzutow
%na falki, a dupaL to funkcje skalujace - by miec baze, na ostatnim poziomie trzeba
%uzywac tez funkcji skalujacych).
%
%Im wiecej bedzie poziomow tym dluzsze beda znieksztalcenia na brzegach sygnalow 
%(trzeba wiec brac odpowiednio dluga rozbiegowke i koncowke ~3*2^poziomy). Nie nalezy wiec
%brac zbyt wielu poziomow jesli nie ma takiej potrzeby.
%ZAWSZE JEDNAK WARTO SPRAWDZIC NA PRZYKLADOWYM SYGNALE JAK JEGO REKONSTRUKCJA
%(BEZ ZADNYCH OBROBEK WSPOLCZYNNIKOW) ROZNI SIE OD ORYGINALU
%ROZNICE TA MOZNA OBEJRZEC NAJPROSCIEJ NASTEPUJACO:
%figure;plot(x-rx);% gdzie rx to zrekonstuowany x.


[m,n]=size(dupa);	%zakladam, ze sygnaly sa w kolumnach!!!

%Najlepiej, zeby sygnaly dlugosc sygnalow byla potega dwojki (...,512,1024,2048,...)
%albo wielokrotnoscia potegi dwojki, ale na tyle duzej potegi, zeby nic sie 
%nie rozjezdzalo.
%Dlugosc sygnalu musi byc wielokrotnoscia potegi dwojki nie nizszej od ilosci 
%uzywanych poziomow!!!

if rem(m,2^poziomy)==0	%jesli dlugosc sygnalu jest wielokrotnoscia 2^poziomy (pozwala 
   %to na rekonstrukcje sygnalu tej samej dlugosci)
   
   
   dupaL{1}=dupa;	
   
   %dupaL i dupaH to beda sygnaly przefiltrowane na kolejnych poziomach
   %na razie dupaL{1} nie przefitrowane, ale potem zostanie podmienione
   %(chodzi tu tylko o wygode w algorytmie)
   
   
   mp=m;	%to dlugosc ktora bedzie zmieniac sie na roznych poziomach (ilosc wyliczanych wspolczynnikow)
   
   %DEKOMPOZYSZYN
   
   for p=1:poziomy,	%moze rozsadniej byloby nazwac ta zminna j nie p
      
      dupah=zeros(mp+lenH-1,n);	%zainicjowanie zmiennych
      dupal=zeros(mp+lenL-1,n);
      
      
      %filtrowanie (convolution)
      if p==1
         dupah=conv2(dupaL{p},fH);	%dupaL{1} trzeba bedzie zmienic, bo to beda
         dupal=conv2(dupaL{p},fL);	%juz przefiltrowane sygnaly
      else
         dupah=conv2(dupaL{p-1},fH);	%kolejne filtrowanie juz przefiltowanego 
         dupal=conv2(dupaL{p-1},fL);	%dlatego z indexem {p-1}
      end;      
      dupah=dupah(lenH/2:end-(lenH/2),:);	%obciecie za dlugich koncowek po filtrowaniu
      dupal=dupal(lenL/2:end-(lenL/2),:);	
      
      
      dupah=dupah(1:2:end,:);		%przerzedzanie (a moze przezedzanie? - nigdy nie bylem dobry z ortografii)
      dupal=dupal(1:2:end,:);
      
      dupaH{p}=dupah;	%wstawienie do macierzy komorkowej juz przefiltorwanych sygnalow
      dupaL{p}=dupal;	%jesli p==1 to dupaL{1} zostaje "podmienione" na to co trzeba
      
      %   do rekonstrukcji interesujace sa tylko dupaL{poziomy} oraz dupaH{p}
      % - dupaL tylko na ostatnim poziomie
      
      mp=length(dupaH{p}(:,1));	%dlugosc "sygnalu" na poziomie scisniecia p
      %a dokladniej to ilosc wyliczonych na danym poziomie wspolczynnikow
      
   end;	% for p=1:poziomy
   
   
   for p=1:poziomy
      wspol{p}=dupaH{p};	%wstawienie do wyniku rzutow na kolejne poziomy falek
   end;
   wspol{poziomy+1}=dupaL{poziomy};	%wstawienie do wyniku rzutow na f. skalujace
   
else	%if rem(m,2^poziomy)~=0
   
   error('Length of the signal is not dividable by 2^(number_of_levels)');
   
end;	%if rem(m,2^poziomy)~=0
