function sygrec=wvreconstr(wspol);
%WVRECONSTR funkcja do rekonstrukcji sygnalow na podstawie wspolczynnikow falkowych
%	SYGREC=WVRECONSTR(WSPOL), a WSPOL bylo wynikiem dzialania WVDECOMP.M - ewentualnie po 
%	przerobkach i odszumianiu (wyzerowywaniu wybranych wspolczynnikw). 
%	W wyniku daje macierz SYGREC ze zrekonstruowanymi na podstawie wspolczynnkiow 
%	sygnalami (w kolumnach).
%	Jesli nic nie bylo wyrzucane, to zrekonstruowany sygnal bedzie taki 
%	jak sygnal pierwotny z bledem wzglednym mniejszym niz 1/1000 poza 
%	koncowkami dlugosci ~3*2^N, gdzie N to ilosc poziomow uzytych do 
%	decompozycji.
%
%	See also WGVDECOMP, ROBFALKEF

%copyright (c) 2002 by Marek Wypych
%Laboratory of Visual System
%Nencki Institute of Experimental Biology, 3 Pasteur Street, 02-093 Warsaw, Poland;


poziomy=length(wspol)-6;	%ilosc poziomow sciskania

for J=1:poziomy+1
   wycineczek{J}=wspol{J,3};
end;

%SERCE SKRYPTU
sygrec=reconstr(wycineczek);	%reconstrukcja
%KONIEC SERCA Z KRYPTY


%-------------------------
%subfunction 'reconstr'
function dupar=reconstr(wspol);

%RECONST - rekonstrukcja falkowa (odwrotna transformata falkowa).
%	RECONSTR(WSPOL);
%	dziala na macierzy komorkowej wyrzuconej przez DECOMP.M (i ew. 
%	przetworzonej w celu odszumienia, kompresji itp...). Daje w wyniku 
%	rekonstrukcje Xr sygnalow X (kolumny to sygnaly) gdzie bylo 
%	wspol=decomp(X).
%	Jesli nic nie bylo wyrzucane, to zrekonstruowany sygnal bedzie taki
%	jak sygnal pierwotny z bledem wzglednym mniejszym niz 1/1000 poza 
%	koncowkami dlugosci ~3*2^N, gdzie N to ilosc poziomow uzytych do
%	decompozycji.
%



%fL to lowpass filter (filtr dolnoprzepustowy - odpowiadajacy funkcji skalujacej)
%jest to 10 wspolczynnikow 
%Musi byc uzyty dokladnie ten sam filtr, co w funkcji DECOMP.M i ROBFALKEF.M !!!!!

fL =[0.16010239797419  0.60382926979719  0.72430852843777    0.13842814590132  -0.24229488706638  -0.03224486958464  0.07757149384005  -0.00624149021280  -0.01258075199908  0.00333572528547 ];	%D10 scaling function


%disp(' ');
%disp('Przy duzej ilosci dlugich danych to moze troche potrwac...');
%disp(' ');

lenL=length(fL);

%recL i recH to filtry do rekonstrukcji (wspolczynniki sa te same, tylko
%zmienia sie ich kolejnosc i czasem plusy czy minusy


for i=1:lenL		
   recL(i)=fL(lenL-i+1);
end;

for i=1:lenL		
   recH(i)=fL(i)*(-1)^(i);
end;

[a,b]=size(recL);if a==1 recL=recL';end;	
[a,b]=size(recH);if a==1 recH=recH';end;
%musi tak byc, zeby filtry i sygnaly byly "pionowe" (kolumny), 
%bo uzywane bedzie conv2, a nie conv, co znacznie przyspiesza, 
%bo mozna filtrowac od razu cala macierz

lenrH=length(recH);
lenrL=length(recL);	%w zasadzie to ciut bez sensu, bo w przypadku falek Daubechies
%zawsze dlugosci filtrow beda takie same

poziomy=length(wspol)-1;	%ilosc poziomow ktore maja byc uzyte do rekonstrukcji sygnalu
%i ktore byly uzyte do dekompozycji.
%jesli robione byly jakies odszumiania lub inne sztuczki, to niepotrzebne
%wpolczynniki nalezalo tam zamienic na zera 

%	REKONSTRAKSZYN   

for p=1:poziomy
   dupaH{p}=wspol{p};
end;
dupaL{poziomy}=wspol{poziomy+1};


dupar=dupaL{poziomy};	%najpierw z najnizszego poziomu L - jako "residuum"
n=length(dupar(1,:));


for p=poziomy:-1:1	%moze rozsadniej byloby nazwac ta zminna j nie p
   
   mp=length(dupar(:,1));	%zmienna dlugosc przefiltrowanych sygnalow (ilosc wspolczynnikow na danym poziome)
   dl=[dupar(:)';zeros(1,mp*n)];	%wstawianie zer co drugie miejsce
   
   dupazl=reshape(dl(:),2*mp,n);	%nadawanie postaci macierzy
   
   duparl=conv2(dupazl,recL);	%convolution to filtrowanie
   duparl=duparl(lenrL/2+1:end-lenrL/2+1,:);	%obcinanie koncowek
   
   
   dupah=dupaH{p};   
   mp=length(dupah(:,1));
   dh=[dupah(:)';zeros(1,mp*n)];	%wstawianie zer co drugie miejsce
   
   dupazh=reshape(dh(:),2*mp,n);	%nadawanie postaci macierzy
   
   
   duparh=conv2(dupazh,recH);	%convolution czyli filtrowanie      
   duparh=duparh(lenrH/2+1:end-lenrH/2+1,:);	%obcinanie koncowek
   
   
   dupar=(duparh+duparl);
   
   
end;	% for p=poziomy:-1:1
