function faljks=robfalkef(J,K,siglen,co);

%ROBFALKEF funkcja, dajaca w wyniku znormalizowana falke lub funkcje skalujaca.
%	ROBFALKEF(J,K,N) daje w wyniku falke dlugosci N (do analiz sygnalow 
%	dlugosci N) na poziomie scisniecia J o przesunieciu K (dlugosc 
%	pojedynczego "przesuniecia podstawowego" zalezy od poziomu J). 
%	ROBFALKEF(J,K,N) dziala jak ROBFALKEF(J,K,N,0) i robi falke
%	ROBFAKLEF(J,K,N,1) robi funkcje skalujaca.
%	W przypadku J>10 funkcja dzialac bedzie powoli, jesli zas
%	J<=10 to ladowane sa obliczone wczesniej funkcje z pliku falfskal.mat
%
%	UWAGA!!!
%	Jesli J<=10 to ladowane sa obliczone wczesniej funkcje z pliku falfskal.mat
%	Plik ten musi znajdowac sie w bierzacym katalogu lub w katalogu z
%	aktywna sciezka dostepu.
%
%	See also WVDECOMP, WVRECONSTR,


%copyright (c) 2002 by Marek Wypych
%Laboratory of Visual System
%Nencki Institute of Experimental Biology, 3 Pasteur Street, 02-093 Warsaw, Poland;


if nargin==3
   co=0;
end;

if co~=0
   if co~=1
      error('Bledny czwarty parametr funkcji - ma byc 0 lub 1.');
   end;
end;

%	Funkcja robi falke D10 (Daubechies) na podstawie wspolczynnikow zapisanych w fL
%	Dziala poprawnie tylko dla falki D10
%	Musi byc uzyty dokladnie ten sam filtr, co w funkcji DECOMP.M i RECONSTR.M !!!!!

fL =[0.16010239797419  0.60382926979719  0.72430852843777    0.13842814590132  -0.24229488706638  -0.03224486958464  0.07757149384005  -0.00624149021280  -0.01258075199908  0.00333572528547 ];	%D10 scaling function

lenL=length(fL);
lenF=(lenL-1)*2^J;	%dlugosc funkcji (nieprzesunietej)


if J>10	%jesli poziom sciskania nie za wysoki, to laduje z pamieci, zeby nie obliczac, 
   %bo obliczanie trwa dosc dlugo
   
   ile=160;	%ilosc iteracji
   
   fi1=zeros(1,lenF);
   fi2=fi1;
   fi1((lenL-2)*2^J+1:(lenL-1)*2^J)=ones(1,2^J);   
   for j=1:ile		%najpierw robi (iteracyjnie) funkcje skalujaca
      for l=1:lenL
         p=lenF/2-(l-1)*2^J/2;
         fi2(p+1:p+lenF/2)=fi2(p+1:p+lenF/2)+fL(l)*fi1(1:2:end);
      end;
      r(j)=norm(fi1/norm(fi1)-fi2/norm(fi2));
      fi1=fi2;
   end;
   fskal=fi1/norm(fi1);
   
   w=zeros(1,lenF);	%teraz zrobi falke:
   for l=1:lenL
      pocz=lenF/2-(l-1)*2^J/2;
      w(pocz+1:pocz+lenF/2)=w(pocz+1:pocz+lenF/2)+(-1)^(l+1)*fL(lenL-l+1)*fskal(1:2:end);
   end;   
   fal=w/norm(w);
   
   if co==1	%jesli chodzi o funkcje skalujaca
      fal=fskal;
   end;
   
else	%if J<=10
   
   %   falfskal=load('falfskal.mat');
   load falfskal;
   if co==0 
      fal=falfskal{J,1}(1,:);
   else	%co==1
      fal=falfskal{J,2};
   end;
   
end;	%if J<=10

%teraz zeby miala dlugosc siglen i odpowiednie przesuniecie:

faljks=zeros(siglen,1);

pocz=(K-lenL/2-1)*2^J-2	;
kon=pocz+lenF-1;

faljks(max(1,pocz):min(kon,siglen))=fal(max(1,-pocz+2):min(lenF,lenF-(kon-siglen)));	
