function R=RMatrix (nx,ny,nz)

% Macierz R(:,:) pomnozona przez wektor M = (nx+2)*(ny+2)*(nz+2) 
% wartosci funkcji na siatce 3D zwraca wektor  wartosci na 
% obcietej siatce. Obciete sa wartosci brzegowe

n = nx*ny*nz; % tyle jest punktow mniejszej siatki
M = (nx+2)*(ny+2)*(nz+2); % tyle jest punktow powiekszonej siatki

R = zeros(n,M); 

for i=1:n % petla po wezlach mniejszj siatki
    [xk,yk,zk] = wspolrzedne(nx,ny,nz,i); % wspolrzedne punktu w mniejszej siatce
    nr = nr_punktu(nx+2,ny+2,xk+1,yk+1,zk+1); % numer odp. punktu w wiekszej siatce
    R(i,nr) = 1;
end;
