%   Copyright 2006-2010 Szymon Leski
%   s.leski@nencki.gov.pl

function out = NewDatasetGui

appdata.bgcolor = get(0,'DefaultUicontrolBackgroundColor');
appdata.modified = 0;
appdata.modifiedname = 0;
appdata.abandon = 0;
appdata.pots = [];
appdata.potsname = '';
appdata.dx = [];
appdata.dy = [];
appdata.dt = [];
appdata.t0 = [];
appdata.nx = '--';
appdata.ny = '--';


out = [];
handles = [];
gui_layout;
uiwait(handles.fig2);

    function matbtncbk(src, evnt) %#ok<INUSD>
        [matfname, pathname] = ...
            uigetfile('*.mat', 'Please select a MAT file');
        if ~(matfname == 0)
            vars = who('-file', fullfile(pathname, matfname));
            [sel, ok] = listdlg(...
                'ListString',       vars, ...
                'SelectionMode',    'single', ...
                'Name',             'Import from MAT file', ...
                'PromptString',     'Select variable');
            if ok
                appdata.potsname = [matfname ' -> ' vars{sel}];
                tempdata = load(fullfile(pathname, matfname), vars{sel});
                appdata.pots = tempdata.(vars{sel});
                PotsLoadFcn
            end;
        end;
    end % of callback

    function workbtncbk(src, evnt) %#ok<INUSD>
        vars = evalin('base', 'who');
        [sel, ok] = listdlg(...
            'ListString',       vars, ...
            'SelectionMode',    'single', ...
            'Name',             'Import from workspace', ...
            'PromptString',     'Select variable');
        if ok
            appdata.potsname = ['Workspace -> ' vars{sel}];
            tmpfname = [tempname '.mat'];
            savecmd = ['save(''' tmpfname ''', ''' vars{sel} ''');'];
            evalin('base', savecmd);
            tempdata = load(tmpfname);
            appdata.pots = tempdata.(vars{sel});
            delete(tmpfname)
            PotsLoadFcn
        end;
    end % of callback

    function PotsLoadFcn
        appdata.modified = 1;
        appdata.potsname = [appdata.potsname ...
            ' (' num2str(size(appdata.pots)) ')'];
        set(handles.datatxt, 'String', appdata.potsname, ...
            'Enable', 'on');
        potsize = size(appdata.pots);
        if length(potsize) == 3
            set(handles.ntedt, 'String', num2str(potsize(1)));
            set(handles.nxedt, 'String', num2str(potsize(2)));
            set(handles.nyedt, 'String', num2str(potsize(3)));
        end;
        if length(potsize) == 2
            set(handles.ntedt, 'String', num2str(potsize(1)));
            set(handles.nxedt, 'String', num2str(potsize(2)), ...
                'Style', 'edit', 'Callback', @nxedtcbk);
            set(handles.nyedt, 'String', '1', ...
                'Style', 'edit', 'Callback', @nyedtcbk);
        end;
    end

    function nxedtcbk(src, evnt) %#ok<INUSD>
        value = str2double(get(handles.nxedt, 'String'));
        if ~isnan(value) && length(value) == 1
            appdata.nx = num2str(value);
        else
            set(handles.nxedt, 'String', appdata.nx);
        end;
    end % of callback

    function nyedtcbk(src, evnt) %#ok<INUSD>
        value = str2double(get(handles.nyedt, 'String'));
        if ~isnan(value) && length(value) == 1
            appdata.ny = num2str(value);
        else
            set(handles.nyedt, 'String', appdata.ny);
        end;
    end % of callback

    function storenum
        appdata.dx = str2double(get(handles.dxedt, 'String'));
        appdata.dy = str2double(get(handles.dyedt, 'String'));
        appdata.dt = str2double(get(handles.dtedt, 'String'));
        appdata.t0 = str2double(get(handles.t0edt, 'String'));
    end

    function numedtcbk(src, evnt) %#ok<INUSD>
        value = str2double(get(src, 'String'));
        if ~isnan(value) && length(value) == 1
            storenum
        end;
        set(handles.dxedt, 'String', num2str(appdata.dx));
        set(handles.dyedt, 'String', num2str(appdata.dy));
        set(handles.dtedt, 'String', num2str(appdata.dt));
        set(handles.t0edt, 'String', num2str(appdata.t0));
    end % of callback

    function nameedtcbk(src, evnt) %#ok<INUSD>
        %value = get(src, 'String');
        appdata.modifiedname = 1;
    end % of callback

    function okbtncbk(src, evnt) %#ok<INUSD>
        %Init_dataset(...
        proceed = 0;
        if ~appdata.modified
            warndlg('Please load voltage data!', 'No data');
        elseif ~appdata.modifiedname
            button = questdlg(...
                {['New dataset will have the default name' ...
                ' (' get(handles.nameedt, 'String') ').'], ...
                'Do you want to continue?'}, ...
                'Click ''No'' to edit the name', 'Yes', 'No', 'No');
            if strcmp(button, 'Yes')
                proceed = 1;
            end;
        else
            proceed = 1;
        end;
        
        if proceed
            Init_dataset(...
                get(handles.nameedt, 'String'), ...
                appdata.pots, ...
                str2double(get(handles.nxedt, 'String')), ...
                str2double(get(handles.nyedt, 'String')), ...
                str2double(get(handles.dxedt, 'String')), ...
                str2double(get(handles.dyedt, 'String')), ...
                str2double(get(handles.dtedt, 'String')), ...
                str2double(get(handles.t0edt, 'String')), ...
                get(handles.comedt, 'String'));
            out = get(handles.nameedt, 'String');
            close(handles.fig2);
        end;
    end % of callback

    function cancelbtncbk(src, evnt) %#ok<INUSD>
        if appdata.modified
            button = ...
                questdlg('Changes will not be saved! Cancel?',...
                'Really quit?', 'Yes', 'No', 'No');
            if strcmp(button, 'Yes')
                appdata.abandon = 1;
            else
                appdata.abandon = 0;
            end;
        else
            appdata.abandon = 1;
        end;
        if appdata.abandon
            out = [];
            close(handles.fig2);
        end;
    end % of callback

    function gui_layout
        %%% GUI layout for NewDatasetGUI
        handles.fig2 = figure(...
            'Position',     [ 400 300 460 360],  ...
            'Renderer',     'zbuffer', ...
            'MenuBar',      'none', ...
            'Resize',       'off', ...
            'Name',         'iCSD 2D', ...
            'NumberTitle',  'off', ...
            'Color',        appdata.bgcolor);
        movegui(handles.fig2, 'onscreen');

        handles.uipanel1 = uipanel(...
            'Title',       'Voltage data', ...
            'Units',       'pixels', ...
            'Position',     [20 80 420 200]);
        handles.matbtn = uicontrol(...
            'Style',        'pushbutton', ...
            'String',       'MAT file...', ...
            'Position',     [300 100 100 40], ...
            'Callback',     @matbtncbk, ...
            'Parent',       handles.uipanel1, ...
            'TooltipString', 'Import from a MAT file');
        handles.workbtn = uicontrol(...
            'Style',        'pushbutton', ...
            'String',       'Workspace...', ...
            'Position',     [180 100 100 40], ...
            'Callback',     @workbtncbk, ...
            'Parent',       handles.uipanel1, ...
            'TooltipString', 'Import from workspace');
        handles.datatxt = uicontrol(...
            'Style',        'text', ...
            'String',       '(nothing selected)', ...
            'Position',     [20 160 380 20], ...
            'Callback',     '', ...
            'Enable',       'off', ...
            'Parent',       handles.uipanel1);
        handles.importfromtxt = uicontrol(...
            'Style',        'text', ...
            'String',       'Import data from:', ...
            'Position',     [20 110 140 20], ...
            'Callback',     '', ...
            'HorizontalAlignment', 'left', ...
            'Parent',       handles.uipanel1);

        handles.nxtxt = uicontrol(...
            'Style',        'text', ...
            'String',       'nx:', ...
            'Position',     [20 50 30 20], ...
            'Callback',     '', ...
            'Parent',       handles.uipanel1);
        handles.nxedt = uicontrol(...
            'Style',        'text', ...
            'String',       '--', ...
            'Position',     get(handles.nxtxt, 'Position') + [30 0 0 0], ...
            'Callback',     '', ...
            'Parent',       handles.uipanel1);
        handles.nytxt = uicontrol(...
            'Style',        'text', ...
            'String',       'ny:', ...
            'Position',     [100 50 30 20], ...
            'Callback',     '', ...
            'Parent',       handles.uipanel1);
        handles.nyedt = uicontrol(...
            'Style',        'text', ...
            'String',       '--', ...
            'Position',     get(handles.nytxt, 'Position') + [30 0 0 0], ...
            'Callback',     '', ...
            'Parent',       handles.uipanel1);
        handles.nttxt = uicontrol(...
            'Style',        'text', ...
            'String',       'nt:', ...
            'Position',     [20 20 30 20], ...
            'Callback',     '', ...
            'Parent',       handles.uipanel1);
        handles.ntedt = uicontrol(...
            'Style',        'text', ...
            'String',       '--', ...
            'Position',     get(handles.nttxt, 'Position') + [30 0 0 0], ...
            'Callback',     '', ...
            'Parent',       handles.uipanel1);

        handles.dxtxt = uicontrol(...
            'Style',        'text', ...
            'String',       'dx:', ...
            'Position',     [220 50 30 20], ...
            'Callback',     '', ...
            'Parent',       handles.uipanel1);
        handles.dxedt = uicontrol(...
            'Style',        'edit', ...
            'String',       '1', ...
            'Position',     get(handles.dxtxt, 'Position') + [30 0 0 0], ...
            'Callback',     @numedtcbk, ...
            'Parent',       handles.uipanel1);
        handles.dytxt = uicontrol(...
            'Style',        'text', ...
            'String',       'dy:', ...
            'Position',     [300 50 30 20], ...
            'Callback',     '', ...
            'Parent',       handles.uipanel1);
        handles.dyedt = uicontrol(...
            'Style',        'edit', ...
            'String',       '1', ...
            'Position',     get(handles.dytxt, 'Position') + [30 0 0 0], ...
            'Callback',     @numedtcbk, ...
            'Parent',       handles.uipanel1);

        handles.t0txt = uicontrol(...
            'Style',        'text', ...
            'String',       't0:', ...
            'Position',     [220 20 30 20], ...
            'Callback',     '', ...
            'Parent',       handles.uipanel1);
        handles.t0edt = uicontrol(...
            'Style',        'edit', ...
            'String',       '0', ...
            'Position',     get(handles.t0txt, 'Position') + [30 0 0 0], ...
            'Callback',     @numedtcbk, ...
            'Parent',       handles.uipanel1);
        handles.dttxt = uicontrol(...
            'Style',        'text', ...
            'String',       'dt:', ...
            'Position',     [300 20 30 20], ...
            'Callback',     '', ...
            'Parent',       handles.uipanel1);
        handles.dtedt = uicontrol(...
            'Style',        'edit', ...
            'String',       '1', ...
            'Position',     get(handles.dttxt, 'Position') + [30 0 0 0], ...
            'Callback',     @numedtcbk, ...
            'Parent',       handles.uipanel1);

        handles.okbtn = uicontrol(...
            'Style',        'pushbutton', ...
            'String',       'OK', ...
            'Position',     [110 20 100 40], ...
            'Callback',     @okbtncbk);
        handles.cancelbtn = uicontrol(...
            'Style',        'pushbutton', ...
            'String',       'Cancel', ...
            'Position',     [250 20 100 40], ...
            'Callback',     @cancelbtncbk);

        handles.nametxt = uicontrol(...
            'Style',        'text', ...
            'String',       'Name', ...
            'Position',     [20 320 140 20], ...
            'Callback',     '');
        handles.nameedt = uicontrol(...
            'Style',        'edit', ...
            'String',       'new_dataset', ...
            'Position',     [20 300 140 20], ...
            'Callback',     @nameedtcbk);

        handles.comtxt = uicontrol(...
            'Style',        'text', ...
            'String',       'Comment', ...
            'Position',     [200 320 240 20], ...
            'Callback',     '');
        handles.comedt = uicontrol(...
            'Style',        'edit', ...
            'String',       'Please provide short description', ...
            'Position',     [200 300 240 20], ...
            'Callback',     '');
        
        storenum

    end % of gui_layout
end % of all
