function ensemble=PSVM_boost_channels(A,Y,nu,T)
    [num_of_objects num_of_channels N]=size(A)
    
    t=0;
    B=speye(num_of_objects)/num_of_objects;
    while(t<T)        
        for c=1:num_of_channels
            A_c=squeeze(A(:,c,:));
            [w g]=PSVM_build(A_c,diag(Y),nu,B);
            y=diag(Y)*(A_c*w-g);
            err=sum(B*(y<=0));
            alpha=0.5*log((1+err)/(1-err));
            [c err alpha]
        end
        t=t+1;
    end