function S=RF_calc_proximities(m,T,A,Y,num_of_classes)
    num_of_objects=length(Y);
    forest.trees=cell(T,1);
    forest.num_of_classes=num_of_classes;    
    S=zeros(num_of_objects,num_of_objects);
    for t=1:T         
        inbag=randsample(num_of_objects,num_of_objects,true);
        forest.trees{t}=RF_build_randcomb_tree(A,Y(inbag),m,num_of_classes);
        outbag=setdiff(1:num_of_objects,unique(inbag));
        S=S+RF_calc_tree_proximities(A,forest.trees{t});
        if(mod(t,10) == 0)
            display(t)
        end
    end    
    S=S/T;