function tree=RF_build_tree(m,L,A_d,Y,sample,num_of_classes)
%    tree_size=2^(rows(A_d));
    max_level=6;
    tree_size=2^10;
    num_of_objects=length(Y);
    levels=length(A_d);

    %tree stuff
    tree.leaf=sparse(tree_size,1);
    tree.cut=sparse(tree_size,1);
    tree.split=false(tree_size,num_of_objects);
    tree.class_stats=zeros(tree_size,num_of_classes);
    
    %lifting stuff
    tree.k=sparse(tree_size,1); %best k
    tree.level=sparse(tree_size,1); %best level
    tree.w=sparse(tree_size,L+1); %best weight vector
    
    A_loc=zeros(num_of_objects,m);
    
    level=0;
    node=1;
    classified=0;
    returned=0; %0-nothing, 1 - from left, 2 - from right   
    
    while(true)
        parent_node=floor(node/2);
        left_node=node*2;
        right_node=node*2+1;
        %
        %Flow-control
        %
        if(returned==1) %returned from left node
            node=right_node; %go to right node
            returned=0;
            continue;            
        else
            if(returned==2) %returned from right node
                if(node==1) %the tree is ready
                    break;
                end
                %go back one level 1
                returned=1+mod(node,2);
                node=parent_node;                
        	level=level-1;
                continue
            end
        end
        
                     
        %
        % Build a new node
        %

        if(node == 1)
            tree.split(node,:)=true(1,num_of_objects);
        end
        node_split=tree.split(node,:);  
        
    	%if(sum(node_split) == 0)
        %   disp('Empty node!')
    	%   disp(node)
        %   %go back one level
        %   returned=1+mod(node,2);	    
        %   node=parent_node;         
        %   level=level-1;
        %   continue;
        %end	

        tree.class_stats(node,:)=RF_calc_stats(Y(node_split),num_of_classes);
        
        %is it a leaf?
        if (sum(tree.class_stats(node,:)>0)==1) || (level>=max_level)
            %increase number of objects being classified
            classified=classified+sum(tree.split(node,:));
            tree.leaf(node)=1;
            
            %go back one level
            returned=1+mod(node,2);	    
            node=parent_node;            
            continue;
        end
          
        %draw random levels, indices and weights
        rlevels=floor(rand(m,1)*levels)+1;
        rk=zeros(m,1);
        for a=1:m
            K=columns(A_d{rlevels(a)}.D);
            rk(a)=floor(rand*K)+1;
        end
        rw=2*rand(L+1,m)-1;
        rw(1,:)=1;
%        rw(2:end,:)=rw(2:end,:).*repmat((1./sum(rw(2:end,:))),L,1);
        
        %build local decision table
        for a=1:m
%            [w g u]=PSVM_build(LIFT_create_local_table(rk(a),L,A_d{rlevels(a)}.C(sample(node_split),:),A_d{rlevels(a)}.D(sample(node_split),:)),diag(Y(node_split)),1);            
%            rw(:,a)=w;
            A_loc(node_split,a)=LIFT_predict(rw(:,a),rk(a),L,A_d{rlevels(a)}.C(sample(node_split),:),A_d{rlevels(a)}.D(sample(node_split),:));
        end
        
        [a c f]=RF_find_best_cut(A_loc(node_split,:),Y(node_split),num_of_classes);
        
        tree.k(node)=rk(a);
        tree.level(node)=rlevels(a);
        tree.w(node,:)=rw(:,a)';
        tree.cut(node)=c;              
         
        
        if(sum((A_loc(:,a)<=c)&node_split')>0 && ...
           sum((A_loc(:,a)>c)&node_split')>0)            
            
            %
            % Update children splits
            %
            %left child (<=)            
            tree.split(left_node,:)=(A_loc(:,a) <= c) & node_split';
            %right child (>)
            tree.split(right_node,:)=(A_loc(:,a) > c) & node_split'; 
        
            %go to left node
            level=level+1;
            node=left_node;       
        else
           disp(tree.class_stats(node,:))
	   disp(f)
           returned=1+mod(node,2);	    
           tree.leaf(node)=1;
           node=parent_node;         
           level=level-1;
        end
    end
    
    
