function [error forest]=RF_build_forest(m,L,levels,T,A,Y,num_of_classes)
    num_of_objects=length(Y);
    forest.trees=cell(T,1);
    forest.num_of_classes=num_of_classes;    
    votes=zeros(num_of_objects,T);
    error=zeros(T,1);

%    disp('Preparing data...')
    A_d=LIFT_prepare_levels(levels,A);
%    disp('done')
    for t=1:T   
        inbag=randsample(num_of_objects,num_of_objects,true);
    	forest.trees{t}=RF_build_tree(m,L,A_d,Y(inbag),inbag,num_of_classes);
        
        outbag=setdiff(1:num_of_objects,unique(inbag));
        y=RF_classify_tree(L,A_d,outbag,forest.trees{t});

        votes(outbag,t)=y;
        error(t)=sum(RF_vote_predictions(votes(:,1:t),num_of_classes) ~= Y);
%        if ~mod(t,10)
            fprintf('                                                    \r');
            fprintf('Iteration: %d -> %f\r',t,(error(t)/num_of_objects));
%        end
    end    
    fprintf('\n');
