function psvm=PSVM_build(A, Y, W, params)
    %function [w g u]=PSVM_build(A,Y,nu,B)
    %A  - matrix with training examples with rows being analysed objects
    %Y  - diagonal matrix with labels (-1 or +1) at its main diagonal
    %nu - nu controls how much you want to fit the model to training data
    %W  - a vector with weights for each training example 
    psvm.nu=params.nu;
    psvm.nsvs=params.nsvs;
    
    %select training vector with weights > 0
    %nonzeros=find(W>0);
    %W=W(nonzeros); W=W/sum(W);
    %Y=diag(Y); Y=Y(nonzeros);
    %Y=spdiags(Y,0, length(Y), length(Y));
    %A=A(nonzeros,:);
    
    W=W/max(W);
    
    if params.normalize==true
        psvm.normalize_coeffs=DATA_calc_normalize_coeffs(A);
        A=DATA_normalize_with_coeffs(A, psvm.normalize_coeffs);
        psvm.normalize=true;
    else
        psvm.normalize=false;
    end
        
    psvm.svs=PSVM_select_svs(A, full(diag(Y)), params.nsvs);
    K=A;
    if ~strcmp(params.kernel.name, 'linear') || params.nsvs<1.0
        K=PSVM_create_kernel(A, psvm.svs, params.kernel);
    end
    [m n]=size(K);
    e=ones(m,1);    
    H=Y*[K -e];       
    if(size(K,2) < size(K,1))        
        MW=spdiags(W,0,length(W),length(W));
        %HW=H'*MW;
        %r=sum(HW')';
        %r=(speye(n+1)/psvm.nu + HW*H)\r;
        %u=psvm.nu*MW*(1-H*r);                       
        %r=sum(H)';
        %r=(speye(n+1)./psvm.nu + H'*H)\r;
        %u=psvm.nu*(1-H*r);
	r=(speye(n+1)./psvm.nu + H'*MW*H)\(H'*MW*e);
	psvm.w=r(1:end-1);
	psvm.g=r(end);
	%calc PRESS (predicted residual sum of squares)
	if params.calc_press==true
		hii=W.*diag(H*((speye(n+1)./psvm.nu + H'*MW*H)\H'));
		psvm.press=sum(((H*r - 1)./(1-hii)).^2);	
	else	
		psvm.press=-1;
	end
    else
        u=(spdiags(1./W, 0, length(W), length(W))/psvm.nu + H*H')\e;
        %u=(speye(size(A,1))/psvm.nu + H*H')\e;
	s=Y*u;
        psvm.w=(s'*K)';
	psvm.g=-sum(s);   
	psvm.press=-1;
    end
    
     
    psvm.kernel=params.kernel;    
