function S=RF_calc_tree_proximities(A,tree)
    num_of_objects=rows(A);
    nodes=zeros(num_of_objects,1);
    for o=1:num_of_objects
        node=1;
        while(true)
            left_node=2*node;
            right_node=2*node+1;
            %is it a leaf?
            if(tree.leaf(node))
               nodes(o)=node;
               break
            end
        
            w=tree.w(node,:)';
            c=tree.cut(node);       
            
            d=A(o,:)*w;        
            if(d <= c)
                node=left_node;
            else
                node=right_node;
            end
        end
    end   
    
    S=zeros(num_of_objects,num_of_objects);
    for o1=1:num_of_objects        
        for o2=o1:num_of_objects
            if(nodes(o1)==nodes(o2))
                S(o1,o2)=1;
                S(o2,o1)=1;
            end
        end
    end
    