function [vectors atoms]=GABOR_rand_dict(T,N)  
  num_of_scales=floor(log2(N));
  vectors=zeros(N,T*num_of_scales);
  atoms=cell(T*num_of_scales,1); 


  a=1;
  for sc=1:num_of_scales
    s=2^sc; %window width (scale)
    
    for k=1:T
      t=floor(rand*N)+1; %time position
      w=floor(rand*s/2)+1;
      fi=rand*pi;
      
      atoms{a}.k=t;
      atoms{a}.width=w;
      atoms{a}.scale=s;
      atoms{a}.phase=fi;
    
      x=linspace(-pi,pi,s);
      
      atom=(exp((-pi*x.^2)/s).*sin(w*x+fi))';      
      atom=[atom; zeros(N-s,1)];
      atom=atom/norm(atom);
    
      vectors(:,a)=circshift(atom,s-t)';

      a=a+1;
    end
  end