function ensemble=LC_multiclass_nonrandom_arcing(A,Y,parameters)
    %function ensemble=LC_multiclass_boosting(A,Y,parameters)
    %
    %
    % For details see "Using Output Codes to Boost Multiclass Learning 
    % Problems" by Robert E. Schapire
    
    levels=parameters.lifting.levels;
    L=parameters.lifting.L; 
    p=parameters.lifting.p;
    
    T=parameters.arcing.T;
    h=parameters.arcing.h;
    
    classes=DATA_classes(Y);
    ensemble=cell(1,1);
    
    M=zeros(size(A,1),length(classes));
    D=zeros(size(A,1),length(classes));
    
    A_d=LIFT_prepare_levels(levels, A);
    
    t=1;
    while(t<=T)
        if ~mod(t,floor(T/10))
            fprintf('t=%d\t [%3.2f %%]\n',t,100*t/T);
        end
        
        %Calculate weights
        D=1+M.^h;
        D=D/sum(sum(D));
        
        %compute coloring
        positive=randsample(length(classes), ...
            floor(length(classes)/2))';
        negative=setdiff(1:length(classes),positive);
        Y_bin=zeros(length(Y),1);
        Y_bin(ismember(Y,classes(positive)))=+1;
        Y_bin(ismember(Y,classes(negative)))=-1;
        
        %calculate U_t and examples' weights
        D_t=zeros(size(A,1),1);
        for i=1:size(A,1)
            if(ismember(Y(i),classes(positive)))
                D_t(i)=sum(D(i,negative));
            else
                D_t(i)=sum(D(i,positive));
            end
        end
        D_t=D_t/sum(D_t);   
        
        local_classifiers=LC_build_reg(A_d, ...
            spdiags(Y_bin,0,size(A,1),size(A,1)), ...
            D_t, parameters,1:size(A,1));
        
        %Find best classifier	 
        Y_tst_pred=LC_classify_reg(A_d, local_classifiers, ...
            parameters);

        best=LC_find_best(Y_tst_pred, Y, D_t);
        
        A_loc_tst=LIFT_create_local_table(best.k, ...
            parameters.lifting.L, ...
			A_d{best.level}.C, A_d{best.level}.D);
        
        y=PSVM_classify(A_loc_tst, ...
            local_classifiers{best.level}{best.k});       

        %Update weights
        for i=1:length(Y_bin)
            if (y(i)*Y_bin(i) <= 0)
                if (y(i) > 0)
                    M(i,positive)=M(i,positive)+1;
                else
                    M(i,negative)=M(i,negative)+1;
                end
            end
        end	

        %disp([1-best.err best.err])
        
        ensemble{t}.base=best;
        ensemble{t}.psvm=local_classifiers{best.level}{best.k};
        ensemble{t}.positive=positive;
        ensemble{t}.weight=1;
        
        t=t+1;
    end
        
        