function Y_pred=LC_multiclass_classify(ensemble,X,classes,parameters)
%function Y_pred=LC_multiclass_classify(ensemble,X,classes,parameters)
    T=length(ensemble);
  
    votes=zeros(size(X,1),length(classes));       
    X_d=LIFT_prepare_levels(parameters.lifting.levels,X);
    
    for t=1:T
        positive=ensemble{t}.positive;
        negative=setdiff(1:length(classes),ensemble{t}.positive);
        
        X_loc=LIFT_create_local_table(ensemble{t}.base.k, parameters.lifting.L,...
            X_d{ensemble{t}.base.level}.C, X_d{ensemble{t}.base.level}.D);
        y=PSVM_classify(X_loc,ensemble{t}.psvm);        
        
        if size(ensemble{t}.weight,2) < 2 
            votes(y>0 ,positive)=votes(y>0 ,positive)+ensemble{t}.weight;
            votes(y<=0,negative)=votes(y<=0,negative)+ensemble{t}.weight;
        
            votes(y>0, negative)=votes(y>0 ,negative)-ensemble{t}.weight;
            votes(y<=0,positive)=votes(y<=0,positive)-ensemble{t}.weight;
        else
            votes(y>0 ,positive)=votes(y>0 ,positive)+ensemble{t}.weight(1);
            votes(y<=0,negative)=votes(y<=0,negative)+ensemble{t}.weight(2);
        
            votes(y>0, negative)=votes(y>0 ,negative)-ensemble{t}.weight(1);
            votes(y<=0,positive)=votes(y<=0,positive)-ensemble{t}.weight(2);
        end
    end    
    [s i]=max(votes');    
    Y_pred=classes(i');
