function lcs=LC_build_reg(A_d,Y, W, parameters, indices)
%[W i]=build_local_classifiers_reg(A_d,Y,L,nu) - finds local
%classifiers using regularised variant
%INPUT:
%A_d - decomposed training examples, 
%Y - labels for training examples (diagonal matrix)
%W - examples weights (a vector)
%OUTPUT:

lcs=cell(length(A_d),1);
for level=1:length(A_d)
%	fprintf('Level = %d\n', level)
	lcs{level}=cell(size(A_d{level}.D, 2),1);
	for k=1:size(A_d{level}.D,2)
%		fprintf('\tk=%d\n',k)
		X_loc=LIFT_create_local_table(k, parameters.lifting.L,...
			A_d{level}.C(indices,:), A_d{level}.D(indices,:));       
		psvm=PSVM_build(X_loc, Y, W, parameters.psvm);
		lcs{level}{k}=psvm;
	end
end
