function [err_tst err_trn]=LC_PSVM_STACKED_CVK(A,Y,K,nu,levels,L)
    folds=crossvalind('Kfold',Y,K);
    err_tst=zeros(K,1);
    err_trn=zeros(K,1);    

    for k=1:K
        test = (folds==k); train = ~test;
        A_trn=LIFT_prepare_levels(levels,A(train,:));
        A_tst=LIFT_prepare_levels(levels,A(test,:));

        [W i]=build_local_classifiers_noreg(A_trn,diag(Y(train)),L,1,nu);
        d_trn=classify_with_local_classifiers_noreg(A_trn,levels,W);
        [d_tst i]=classify_with_local_classifiers_noreg(A_tst,levels,W);        
        
        d_trn=d_trn(:,i(1)+1:end);
        d_tst=d_tst(:,i(1)+1:end);
        
        [w g u]=PSVM_build(d_trn,diag(Y(train)),0.001,speye(rows(d_trn)));        
        
        err_trn(k)=mean(Y(train).*(d_trn*w-g) <= 0);
        err_tst(k)=mean(Y(test).*(d_tst*w-g) <= 0);
    end