function ARFF_save(X,Y,fname)
    [objs  attr]=size(X);
    nclass=length(unique(Y));
    classes=unique(Y);
    
    fd=fopen(fname,'w');
    fprintf(fd,'@relation %s\n',fname);
    for a=1:attr
        fprintf(fd,'@attribute A%d numeric\n',a);
    end
    fprintf(fd,'@attribute class {');
    for c=1:nclass-1
        fprintf(fd,'%d,',classes(c));
    end
    fprintf(fd,'%d}\n',classes(nclass));
    fprintf(fd,'@data\n');
    for o=1:objs
        for a=1:attr
            fprintf(fd,'%f , ',X(o,a));
        end
        fprintf(fd,'%d\n',Y(o));
    end
    fclose(fd);
