##########################################################################
#                                                                        #
#           copyright (c) 2004 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""SOAPTool's main class"""

# Zope stuff
from Globals import InitializeClass 
from AccessControl import ClassSecurityInfo
from OFS.Folder import Folder

# CMF stuff
from Products.CMFCore.ActionProviderBase import ActionProviderBase
from Products.CMFCore.CMFCorePermissions import View
from Products.CMFCore.utils import UniqueObject

# custom stuff
from Products.DistributedSearch.SEParser import ParseSoapMessage
from Products.DistributedSearch.SESendSoap import Request

class SoapTool(ParseSoapMessage, Request,
               UniqueObject, Folder, ActionProviderBase):
    """
        Tool for managing my various extensions.
    """

    id = 'soap_tool'
    meta_type = 'Soap Tool'
    
    security = ClassSecurityInfo()
    security.declareObjectProtected(View)
    
    manage_options = (
        (Folder.manage_options[0],)
        # + ActionProviderBase.manage_options
        + Folder.manage_options[2:]

        )
   
InitializeClass(SoapTool)
