#Documentation string
__doc__="""OWL initialization module."""
#Product release
__version__='0.2'

#Import the class and its constructors
from OWL import OWL, manage_addOWLForm, manage_addOWL, OWLinit

#Import my generic ZPT Macros
from Products.JMUtils.JMZPTMacros import JMZPTMacros

#Method to register the class in the ZODB
def initialize(context):
  try:
    OWLinit()
    #Registers the class in the ZopeDB
    context.registerClass(OWL, #Class Module name
                          constructors=( #Constructor forms and methods
                            manage_addOWLForm,
                            manage_addOWL,
                            #These two lines are neccessary in order to
                            #access the macros from the constructor
                            #methods
                            JMZPTMacros.generic,
                            JMZPTMacros.generic_add,
                          ),
                          #I use the folder "images" to store my icons and pictures,
                          #but you may use "www", which is the standard. For me
                          #World Wide Web is really general and it could mean lots
                          #of things like javascripts, css, html, java, cgi, images,
                          #..., etc, so I decided to use "images", which has a more
                          #meanful name
                          icon='images/OWL.gif' #Icon location (16x16 gif file)
                         )
    #Registers the online help
    context.registerHelp()
  #Just in case something fails write the exception
  except:
    from sys import exc_info, stderr
    from traceback import format_exception
    from string import join

    type,val,tb=exc_info()
    stderr.write(join(format_exception(type, val, tb),''))

    del type,val,tb
