# FILE: OntologyTool.py
#
# ontology tool install module
#
# (C) 2003-2004 by CC Open Computer Systems for the "Neuroinfo" project
# This is free software avaiable under the GPL license, see:
#   LICENSE.txt, README.txt for details.
# ==================================================================
##########################################################################
#                                                                        #
#           copyright (c) 2004 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""Ontology Tool's main class"""

# Zope stuff
from Globals import InitializeClass 
from AccessControl import ClassSecurityInfo
from OFS.Folder import Folder

# CMF stuff
from Products.CMFCore.ActionProviderBase import ActionProviderBase
from Products.CMFCore.CMFCorePermissions import View
from Products.CMFCore.utils import UniqueObject

# custom stuff
from Products.OntologyKeys.OKeyParser import ParseXmlOKey
from Products.OntologyKeys.OWL import OWL

from Products.OntologyKeys.OWL import OWLinit

class OntologyTool(ParseXmlOKey, OWL,
               UniqueObject, Folder, ActionProviderBase):
    """
        Tool for managing my various extensions.
    """

    id = 'ontology_tool'
    meta_type = 'Ontology Tool'
    
    security = ClassSecurityInfo()
    security.declareObjectProtected(View)
    
    manage_options = (
        (Folder.manage_options[0],)
        # + ActionProviderBase.manage_options
        + Folder.manage_options[2:]

        )
   
InitializeClass(OntologyTool)
