# FILE: OWL.py
#
# plone installer script
#
# (C) 2003-2004 by CC Open Computer Systems for the "Neuroinfo" project
# This is free software avaiable under the GPL license, see:
#   LICENSE.txt, README.txt for details.
# ======================================================================
##########################################################################
#                                                                        #
#           copyright (c) 2004 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""plone installer script"""

from StringIO import StringIO

from Products.CMFCore.utils import getToolByName

from Products.Archetypes.Extensions.utils import install_subskin

from Products.OntologyKeys.config import *
from Products.OntologyKeys import OntologyTool


def setupTools(self, out):
    """
    adds soap_tool to the portal root folder
    """
    if hasattr(self, 'ontology_tool'):
        self.manage_delObjects(['ontology_tool'])
        out.write('Deleting old ontology_tool; make sure you repeat customizations.')
    addTool = self.manage_addProduct['OntologyKeys'].manage_addTool
    addTool('Ontology Tool', None)
    out.write("\nAdded ontology_tool to the portal root folder.\n")


def install(self):
    out = StringIO()
    setupTools(self, out)
    install_subskin(self, out, GLOBALS)
    print >> out, "Successfully installed %s." % PROJECTNAME
    return out.getvalue()
