function A = ca2(lat_length, time, prob, init_type)

% A naive implementation of "Life"
%
% lat_length = 101;
% time = 200;
% rule_nr = 30;
% prob = 0.1;

%initial state
A = zeros(time,lat_length,lat_length);
if (init_type == 1)
    A(1,:,:)=(rand(lat_length,lat_length) < prob);
elseif (init_type == 2)
    mid=floor((lat_length+1)/2);
    A(1, mid  , mid  ) = 1;
    A(1, mid  , mid-1) = 1;
    A(1, mid+1, mid  ) = 1;
    A(1, mid-1, mid  ) = 1;
    A(1, mid+1, mid+1) = 1;
    A(1, mid-1, mid+1) = 1;
end

%imagesc(squeeze(A(1,:,:)))
for i = 1:(time-1)
    % I do not touch the borders to keep
    % Dirichlet boundary conditions
    for j = 2:lat_length-1
        for k = 2:lat_length-1
            nbhd = squeeze(A(i,j-1:j+1,k-1:k+1));
            howmanynbs = sum(sum(nbhd));
            if (nbhd(2,2) == 0) % dead cell
                if (howmanynbs == 3)
                    A(i+1, j, k) = 1;
                else
                    A(i+1, j, k) = 0;
                end
            else % alive cell, counted in howmanynbs
                if ((howmanynbs < 3) || (howmanynbs >4))
                    A(i+1, j, k) = 0;
                else
                    A(i+1, j, k) = 1;
                end
            end
        end
    end

end

